

IF EXISTS(SELECT 1 FROM AUTH.Clients WHERE ClientId = 'MobiliseApp')
BEGIN

-------- UPDATING MOBILISE APP CLIENT ID TO REMOVE CLIENT CREDENTIALS GRANT TYPE 
DECLARE @ClientId VARCHAR(500)
SET @ClientId = (SELECT Id FROM AUTH.Clients WHERE ClientId = 'MobiliseApp')

DELETE from AUTH.ClientGrantTypes
WHERE ClientId = @ClientId
AND GrantType = 'client_credentials'

UPDATE Auth.Clients
SET RequireClientSecret = 0
WHERE ClientId = 'MobiliseApp'

------------------ GETTING CLIENT SECRET FROM TM SETTINGS

DECLARE @ClientSecret VARCHAR(255)
SET @ClientSecret = (SELECT JSON_VALUE(SET_VALUE, '$.ClientSecret') AS ClientSecret
FROM TM_SETTING WHERE SET_KEY = 'TM.DIARYAPISECURITY')

DECLARE @MobiliseAppClientIdSecretJson VARCHAR(255)
SET @MobiliseAppClientIdSecretJson = '{"ClientID":"MobiliseAppApi","ClientSecret":"' + @ClientSecret  +'"}'


-------------------- Create new client

DECLARE @DefaultApiClient_ScopeList TABLE (Scope NVARCHAR(50))
 -- Add any new Api Scopes as a value in list below 
INSERT INTO @DefaultApiClient_ScopeList VALUES ('visitsApi'), ('usersApi'), ('messagingApi'), ('listsApi'), ('optimiseApi'), ('formsApi'), ('devicesApi'), ('diaryApi'), ('solutionsApi'), ('layoutsApi'), ('smartLookupApi')

DECLARE @DefaultApiClient_Id     VARCHAR(200) = 'MobiliseAppApi'
DECLARE @DefaultApiClient_Secret VARCHAR(200) = @ClientSecret
DECLARE @DefaultApiClient_Identity INT
DECLARE @DefaultApiClient_SecretHash NVARCHAR(max) = (SELECT HASHBYTES('SHA2_256', @DefaultApiClient_Secret))
DECLARE @DefaultApiClient_Base64Hash NVARCHAR(max) = (SELECT CAST(@DefaultApiClient_SecretHash AS VARBINARY(max)) FOR XML PATH(''), BINARY BASE64)

DECLARE @DefaultApiClient_Updated_AbsoluteRefreshTokenLifetime	INT = 86400;
DECLARE @DefaultApiClient_Updated_AccessTokenLifetime			INT = 600;
DECLARE @DefaultApiClient_Original_AbsoluteRefreshTokenLifetime	INT = 2592000;
DECLARE @DefaultApiClient_Original_AccessTokenLifetime			INT = 120;

IF EXISTS(SELECT * FROM Auth.Clients WHERE ClientId = @DefaultApiClient_Id)
	BEGIN
		PRINT 'Existing Client Found'
		SET @DefaultApiClient_Identity = (SELECT Id FROM [Auth].[Clients] WHERE ClientId = @DefaultApiClient_Id)

		IF EXISTS(SELECT * FROM Auth.ClientSecrets WHERE ClientId = @DefaultApiClient_Identity AND [TYPE] = 'SharedSecret')
			BEGIN
				UPDATE Auth.ClientSecrets
				SET VALUE = @DefaultApiClient_Base64Hash
				WHERE ClientId = @DefaultApiClient_Identity AND [TYPE] = 'SharedSecret'
			END
		ELSE
			BEGIN
				INSERT INTO Auth.ClientSecrets (ClientId, [TYPE], VALUE)
				VALUES(@DefaultApiClient_Identity, 'SharedSecret', @DefaultApiClient_Base64Hash)
			END
			
		IF NOT EXISTS(SELECT * FROM Auth.ClientGrantTypes WHERE ClientId = @DefaultApiClient_Identity AND GrantType = 'client_credentials')
			BEGIN
				INSERT INTO Auth.ClientGrantTypes (ClientId, GrantType)
				VALUES(@DefaultApiClient_Identity, 'client_credentials')
			END
			
		UPDATE Auth.Clients 
		SET AbsoluteRefreshTokenLifetime = @DefaultApiClient_Updated_AbsoluteRefreshTokenLifetime, 
			AccessTokenLifetime = @DefaultApiClient_Updated_AccessTokenLifetime 
		WHERE ClientId = @DefaultApiClient_Id 
			AND AbsoluteRefreshTokenLifetime = @DefaultApiClient_Original_AbsoluteRefreshTokenLifetime 
			AND AccessTokenLifetime = @DefaultApiClient_Original_AccessTokenLifetime
	END
ELSE
	BEGIN
		PRINT 'Creating new Client'
		INSERT INTO [Auth].[Clients]
            ([AbsoluteRefreshTokenLifetime]
            ,[AccessTokenLifetime]
            ,[AccessTokenType]
            ,[AllowAccessTokensViaBrowser]
            ,[AllowOfflineAccess]
            ,[AllowPlainTextPkce]
            ,[AllowRememberConsent]
            ,[AlwaysIncludeUserClaimsInIdToken]
            ,[AlwaysSendClientClaims]
            ,[AuthorizationCodeLifetime]
            ,[BackChannelLogoutSessionRequired]
            ,[BackChannelLogoutUri]
            ,[ClientClaimsPrefix]
            ,[ClientId]
            ,[ClientName]
            ,[ClientUri]
            ,[ConsentLifetime]
            ,[Description]
            ,[EnableLocalLogin]
            ,[Enabled]
            ,[FrontChannelLogoutSessionRequired]
            ,[FrontChannelLogoutUri]
            ,[IdentityTokenLifetime]
            ,[IncludeJwtId]
            ,[LogoUri]
            ,[PairWiseSubjectSalt]
            ,[ProtocolType]
            ,[RefreshTokenExpiration]
            ,[RefreshTokenUsage]
            ,[RequireClientSecret]
            ,[RequireConsent]
            ,[RequirePkce]
            ,[SlidingRefreshTokenLifetime]
            ,[UpdateAccessTokenClaimsOnRefresh])
		VALUES
            (@DefaultApiClient_Updated_AbsoluteRefreshTokenLifetime
            ,@DefaultApiClient_Updated_AccessTokenLifetime
            ,0
            ,0
            ,0
            ,0
            ,1
            ,0
            ,1
            ,120
            ,1
            ,null
            ,'client_'
            ,@DefaultApiClient_Id
            ,null
            ,null
            ,null
            ,null
            ,1
            ,1
            ,1
            ,null
            ,300
            ,0
            ,null
            ,null
            ,'oidc'
            ,1
            ,1
            ,1
            ,1
            ,0
            ,1296000
            ,0)
		SET @DefaultApiClient_Identity = (SELECT SCOPE_IDENTITY())

		INSERT INTO Auth.ClientSecrets (ClientId, [TYPE], VALUE)
			VALUES(@DefaultApiClient_Identity, 'SharedSecret', @DefaultApiClient_Base64Hash)
		INSERT INTO Auth.ClientGrantTypes (ClientId, GrantType)
			VALUES(@DefaultApiClient_Identity, 'client_credentials')
	END

----------- Insert any new Scopes for the Client
DECLARE @DefaultApiClient_Scope NVARCHAR(200) = (SELECT Min(Scope) FROM @DefaultApiClient_ScopeList)
WHILE @DefaultApiClient_Scope IS NOT NULL
BEGIN
	IF NOT EXISTS(SELECT * FROM [Auth].[ClientScopes] WHERE Scope = @DefaultApiClient_Scope AND ClientId = @DefaultApiClient_Identity)
	BEGIN
		PRINT 'Adding Scope: ' + @DefaultApiClient_Scope
		INSERT INTO [Auth].[ClientScopes] VALUES(@DefaultApiClient_Identity, @DefaultApiClient_Scope)
	END
	SELECT @DefaultApiClient_Scope = (SELECT Min(Scope) FROM @DefaultApiClient_ScopeList WHERE Scope > @DefaultApiClient_Scope)
END

----------- update setting 
IF EXISTS(SELECT 1 FROM TM_SETTING WHERE SET_KEY = 'TM.DIARYAPISECURITY')
BEGIN
    UPDATE TM_SETTING
	SET SET_VALUE = @MobiliseAppClientIdSecretJson, SET_TIMESTAMP = GETDATE()
	WHERE SET_KEY = 'TM.DIARYAPISECURITY'
END

END



IF EXISTS(SELECT * FROM Auth.Clients WHERE ClientId = 'MobiliseApp' and RequireClientSecret = 0) 
   BEGIN 
     Print 'MobiliseApp successfully updated'
   END
ELSE 
  BEGIN   
     Print 'MobiliseApp failed updated'
  END

IF NOT EXISTS(SELECT * FROM AUTH.ClientGrantTypes WHERE ClientId = @ClientId AND GrantType = 'client_credentials') 
    BEGIN 
      Print 'MobiliseApp Grant type successfully removed'
    END
ELSE 
  BEGIN   
     Print 'MobiliseApp Grant type failed removal'
  END

IF EXISTS(SELECT * FROM Auth.Clients WHERE ClientId = @DefaultApiClient_Id) 
    BEGIN 
      Print 'MobiliseAppApi successfully inserted'
    END
ELSE 
  BEGIN   
     Print 'MobiliseAppApi failed updated'
  END

